﻿<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.HR" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">
    
    public enum Zakres {
        Uzyskane, Utracone, Ważne, Wszystkie
    }

    private Dictionary<Pracownik, List<Wyplata>> dane = new Dictionary<Pracownik, List<Wyplata>>();
    private Date aktualny = Date.Empty;

    class PracownikComparer : IComparer<Pracownik> {
        public int Compare(Pracownik x, Pracownik y) {
            int result = x.NazwiskoImię.CompareTo(y.NazwiskoImię);
            if (result == 0)
                result = x.Kod.CompareTo(y.Kod);
            return result;
        }
    }
    
    protected void dc_ContextLoad(object sender, EventArgs e) {
        FromTo okres = ((OkresContext)dc[typeof(OkresContext)]).Okres;
        aktualny = ((ActualDate)dc[typeof(ActualDate)]).Actual;
        ReportHeader["OKRES"] = okres.ToString();

        List<Wyplata> wyplaty;
        Row[] rows = (Row[])dc[typeof(Row[])];
        foreach (ListaPlac lista in rows)
            foreach (Wyplata wyplata in lista.Wyplaty)
                if (!dane.TryGetValue(wyplata.Pracownik, out wyplaty)) {
                    wyplaty = new List<Wyplata>();
                    wyplaty.Add(wyplata);
                    dane.Add(wyplata.Pracownik, wyplaty);
                }
                else
                    wyplaty.Add(wyplata);

        List<Pracownik> result = new List<Pracownik>(dane.Keys);
        result.Sort(new PracownikComparer());
        Grid1.DataSource = result;
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        Pracownik pracownik = (Pracownik)args.Row;
                
        bool any = false;
        decimal podstawa = 0;
        decimal składka = 0;

        List<Wyplata> wyplaty = dane[pracownik];
        foreach (Wyplata w in wyplaty)
            foreach (WypElement e in w.Elementy) {
                if (e.Podatki.FEP.Podstawa == 0 && e.Podatki.FEP.Skladka == 0)
                    continue;
                podstawa += e.Podatki.FEP.Podstawa;
                składka += e.Podatki.FEP.Skladka;
                any = true;
            }

        colPodstawa.EditValue = podstawa;
        colSkładka.EditValue = składka;
        if (pracownik[aktualny].Etat != null && pracownik[aktualny].Etat.Wydzial != null)
            colWydzial.EditValue = pracownik[aktualny].Etat.Wydzial.Kod;
        
        args.VisibleRow = any;
    }
    
</script>

<HTML>
	<HEAD>
		<TITLE>Znajomość języków obcych</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" 
                title="Zestawienie składek na Fundusz Emerytur Pomostowych||</strong>Za okres: <strong>%OKRES%"></eb:ReportHeader>
			<ea:Grid id="Grid1" runat="server" 
                RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" 
                onbeforerow="Grid1_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Nazwisko" EncodeHTML="true" Caption="Nazwisko"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Imie" EncodeHTML="true" 
                        Caption="Imie" Width="16" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Kod" EncodeHTML="true" 
                        Caption="Kod" Width="14" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" 
                        ID="colWydzial" EncodeHTML="true" 
                        Caption="Wydział" Width="24" NoWrap="True" Total="Info"></ea:GridColumn>
				    <ea:GridColumn ID="colPodstawa" runat="server" Caption="Składki na FEP~podstawa" 
                        Width="12" VAlign="Top" Align="Right" Format="{0:n}" HideZero="True" 
                        Total="Sum">
                    </ea:GridColumn>
				    <ea:GridColumn ID="colSkładka" runat="server" BgColor="" 
                        Caption="Składki na FEP~składka" CssClass="" FontColor="" FontFamily="" 
                        FontSize="" Width="10" WithBarcode="None" Format="{0:n}" Align="Right" 
                        HideZero="True" Total="Sum">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

